<?php

// + zapisz wymiary produktu

namespace RTNET;

class StoreExtensions extends Store
{
    /**
     *
     * @param CreateProductsCommand $request
     */
    public function AfterCreateProductsCommand($request, &$result)
    {
        $request->update_weight = true;
        $this->AfterUpdateProductsCommand($request, $result);
    }

    /**
     *
     * @param UpdateProductsCommand $request
     */
    public function AfterUpdateProductsCommand($request, &$result)
    {
        if ($this->update_weight || filter_var($request->update_weight, FILTER_VALIDATE_BOOLEAN)) {
            $this->db->query("START TRANSACTION;");
            try {

                foreach ($request->Products->Product as $product) {
                    $product_id = $this->GetProductId((string) $product->symbol, false);
                    $data = json_decode((string) $product->ExtendedProperties_Json, true);

                    if ($data === null || !$data['dimensions']) {
                        continue;
                    }

                    $this->db->query("UPDATE `" . $this->PREFIX . "product` SET `depth` = '" . (float) $data['dimensions']['depth'] . "', `width` = '" . (float) $data['dimensions']['width'] . "', `height` = '" . (float) $data['dimensions']['height'] . "' WHERE `id_product` = '" . (int) $product_id . "';");
                }

                $this->db->query("COMMIT;");

            } catch (\Exception $e) {
                $this->db->query("ROLLBACK;");

            }
        }
    }
}
